/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertConfigException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.InterruptionThread;
import com.ibm.hwmca.fw.certs.RemovableMediaDevice;
import com.ibm.hwmca.fw.certs.SelfSignedServerCert;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.StreamTracerThread;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

public class CertUtils
implements CertMgtConstants {
    private static String hTTPDExecutable = null;
    private static final String SERVER_DELETE_CERT_COMMAND = "deleteCert";
    private static final String SERVER_USE_NEW_CERT_COMMAND = "installCert";
    private static final int MILLI_SECONDS_PER_DAY = 86400000;
    private static final String TRACE_MASKD = "XCRTUTLD";
    private static final String TRACE_MASKF = "XCRTUTLF";
    private static final String TRACE_MASKT = "XCRTUTLT";

    private CertUtils() {
    }

    public static void main(String[] args) {
        int temp = 0;
        try {
            temp = CertUtils.wholeDaysGreater(new GregorianCalendar(2037, 11, 31).getTime(), new GregorianCalendar().getTime());
            System.out.println("wholeDaysGreater returned " + temp);
            CertUtils.concatenateFiles(new String[]{args[0], args[1]}, args[2]);
        }
        catch (HException e) {
            e.printStackTrace();
        }
    }

    public static void executeCommand(String command) throws HException {
        CertUtils.executeCommand(command, null, false, false, true, true, false, Long.MAX_VALUE);
    }

    public static void executeCommand(String command, String[] env) throws HException {
        CertUtils.executeCommand(command, env, false, false, true, true, false, Long.MAX_VALUE);
    }

    public static void executeCommand(String command, String[] env, boolean showOut, boolean showErr, boolean traceCommand, boolean traceOutAndErr, boolean waitOnStdOutAndErr, long timeout) throws HException {
        StringTokenizer st = null;
        String[] cmdArray = null;
        int numTokens = 0;
        st = new StringTokenizer(command);
        numTokens = st.countTokens();
        if (numTokens > 0) {
            cmdArray = new String[numTokens];
            for (int i = 0; i < numTokens; ++i) {
                cmdArray[i] = st.nextToken();
            }
        } else {
            throw new HException("Command is empty.");
        }
        CertUtils.executeCommand(cmdArray, env, showOut, showErr, traceCommand, traceOutAndErr, waitOnStdOutAndErr, timeout);
    }

    public static void executeCommand(String[] command, String[] env, boolean showOut, boolean showErr, boolean traceCommand, boolean traceOutAndErr, boolean waitOnStdOutAndErr, long timeout) throws HException {
        int i;
        Process tempProcess = null;
        StringBuffer tempBuffer = null;
        tempBuffer = new StringBuffer();
        if (command != null) {
            for (i = 0; i < command.length; ++i) {
                tempBuffer.append(command[i]);
                tempBuffer.append(' ');
            }
            if (tempBuffer.length() > 0) {
                tempBuffer.deleteCharAt(tempBuffer.length() - 1);
            }
        }
        try {
            if (env == null || env.length < 1) {
                if (traceCommand) {
                    Trace.trace(TRACE_MASKF, "Issuing command: " + tempBuffer.toString());
                }
                tempProcess = Runtime.getRuntime().exec(command);
            } else {
                if (traceCommand) {
                    Trace.trace(TRACE_MASKF, "Issuing command: " + tempBuffer.toString() + " with environment variables:");
                    for (i = 0; i < env.length; ++i) {
                        Trace.trace(TRACE_MASKF, env[i]);
                    }
                }
                tempProcess = Runtime.getRuntime().exec(command, env);
            }
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException: " + e.getMessage());
            throw new HException(e);
        }
        CertUtils.finishProcess(tempProcess, tempBuffer.toString(), showOut, showErr, traceCommand, traceOutAndErr, waitOnStdOutAndErr, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishProcess(Process tempProcess, String command, boolean showOut, boolean showErr, boolean traceResult, boolean traceOutAndErr, boolean waitOnStdOutAndErr, long timeout) throws HException {
        int rc = 0;
        StreamTracerThread stdOutThread = null;
        StreamTracerThread stdErrThread = null;
        InterruptionThread interruptionThread = null;
        Thread stdOutThreadHandle = null;
        Thread stdErrThreadHandle = null;
        Thread interruptionThreadHandle = null;
        long expirationTime = 0L;
        long currentTime = 0L;
        boolean threadDone = false;
        boolean commandDone = false;
        try {
            expirationTime = timeout < Long.MAX_VALUE ? (timeout > Long.MAX_VALUE - (currentTime = new GregorianCalendar().getTimeInMillis()) ? Long.MAX_VALUE : currentTime + timeout) : Long.MAX_VALUE;
            if (showOut || traceOutAndErr) {
                stdOutThread = new StreamTracerThread(tempProcess.getInputStream(), showOut, System.out, traceOutAndErr, "STDOUT");
                stdOutThreadHandle = new Thread(stdOutThread);
                stdOutThreadHandle.start();
            }
            if (showErr || traceOutAndErr) {
                stdErrThread = new StreamTracerThread(tempProcess.getErrorStream(), showErr, System.err, traceOutAndErr, "STDERR");
                stdErrThreadHandle = new Thread(stdErrThread);
                stdErrThreadHandle.start();
            }
            if (expirationTime < Long.MAX_VALUE && (currentTime = new GregorianCalendar().getTimeInMillis()) < expirationTime) {
                interruptionThread = new InterruptionThread(Thread.currentThread(), expirationTime);
                interruptionThreadHandle = new Thread(interruptionThread);
                interruptionThreadHandle.start();
            }
            commandDone = false;
            while (expirationTime == Long.MAX_VALUE || new GregorianCalendar().getTimeInMillis() <= expirationTime) {
                try {
                    if (interruptionThreadHandle != null && interruptionThread.isDone()) continue;
                    rc = tempProcess.waitFor();
                    if (traceResult) {
                        Trace.trace(TRACE_MASKF, "The command, " + command + ", returned with an rc of " + rc + ".");
                    }
                    commandDone = true;
                    break;
                }
                catch (InterruptedException e) {
                    Trace.trace(TRACE_MASKF, "Interrupted");
                }
            }
            if (interruptionThreadHandle != null && interruptionThread != null) {
                interruptionThread.setTerminate();
                interruptionThreadHandle.interrupt();
                interruptionThreadHandle = null;
                interruptionThread = null;
            }
            if (!commandDone) {
                tempProcess.destroy();
                if (traceResult) {
                    throw new HException("The command, " + command + ", timed out.");
                }
                throw new HException("The command timed out.");
            }
            if (rc != 0) {
                if (traceResult) {
                    throw new HException("The command, " + command + ", returned with an rc of " + rc);
                }
                throw new HException("The command returned with an rc of " + rc);
            }
            if (waitOnStdOutAndErr) {
                StreamTracerThread streamTracerThread;
                if (stdOutThreadHandle != null) {
                    if (expirationTime < Long.MAX_VALUE && (currentTime = new GregorianCalendar().getTimeInMillis()) < expirationTime) {
                        interruptionThread = new InterruptionThread(stdOutThreadHandle, expirationTime);
                        interruptionThreadHandle = new Thread(interruptionThread);
                        interruptionThreadHandle.start();
                    }
                    threadDone = false;
                    while (expirationTime == Long.MAX_VALUE || new GregorianCalendar().getTimeInMillis() <= expirationTime) {
                        streamTracerThread = stdOutThread;
                        synchronized (streamTracerThread) {
                            if (stdOutThread.isDone()) {
                                threadDone = true;
                                break;
                            }
                            try {
                                if (interruptionThread == null || !interruptionThread.isDone()) {
                                    stdOutThread.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                Trace.trace(TRACE_MASKF, "Interrupted");
                            }
                        }
                    }
                    if (!threadDone) {
                        tempProcess.destroy();
                        throw new HException("Timeout waiting for stdout to be completed.");
                    }
                    if (interruptionThreadHandle != null && interruptionThread != null) {
                        interruptionThread.setTerminate();
                        interruptionThreadHandle.interrupt();
                        interruptionThreadHandle = null;
                        interruptionThread = null;
                    }
                }
                if (stdErrThreadHandle != null) {
                    if (expirationTime < Long.MAX_VALUE && (currentTime = new GregorianCalendar().getTimeInMillis()) < expirationTime) {
                        interruptionThread = new InterruptionThread(stdErrThreadHandle, expirationTime);
                        interruptionThreadHandle = new Thread(interruptionThread);
                        interruptionThreadHandle.start();
                    }
                    threadDone = false;
                    while (expirationTime == Long.MAX_VALUE || new GregorianCalendar().getTimeInMillis() <= expirationTime) {
                        streamTracerThread = stdErrThread;
                        synchronized (streamTracerThread) {
                            if (stdErrThread.isDone()) {
                                threadDone = true;
                                break;
                            }
                            try {
                                if (interruptionThread == null || !interruptionThread.isDone()) {
                                    stdErrThread.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                Trace.trace(TRACE_MASKF, "Interrupted");
                            }
                        }
                    }
                    if (!threadDone) {
                        tempProcess.destroy();
                        throw new HException("Timeout waiting for stderr to be completed.");
                    }
                }
            }
            Object var27_26 = null;
            if (interruptionThreadHandle != null && interruptionThread != null) {
                interruptionThread.setTerminate();
                interruptionThreadHandle.interrupt();
            }
            if (waitOnStdOutAndErr) {
                if (stdOutThreadHandle != null && stdOutThread != null) {
                    stdOutThread.setTerminate();
                    stdOutThreadHandle.interrupt();
                }
                if (stdErrThreadHandle != null && stdErrThread != null) {
                    stdErrThread.setTerminate();
                    stdErrThreadHandle.interrupt();
                }
            }
        }
        catch (Throwable throwable) {
            Object var27_27 = null;
            if (interruptionThreadHandle != null && interruptionThread != null) {
                interruptionThread.setTerminate();
                interruptionThreadHandle.interrupt();
            }
            if (waitOnStdOutAndErr) {
                if (stdOutThreadHandle != null && stdOutThread != null) {
                    stdOutThread.setTerminate();
                    stdOutThreadHandle.interrupt();
                }
                if (stdErrThreadHandle != null && stdErrThread != null) {
                    stdErrThread.setTerminate();
                    stdErrThreadHandle.interrupt();
                }
            }
            throw throwable;
        }
    }

    public static String getFQFileName(String fileName) throws CertConfigException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath(fileName) + fileName;
            if (result == null) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 21).log();
                throw new CertConfigException("Null returned from DDFC while getting the file path for " + fileName + ".", null);
            }
            return result;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting fully qualified name for file name " + fileName + " : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw new CertConfigException("Error getting fully qualified name for " + fileName + ".", e);
        }
    }

    static void doExit(int status) {
        Trace.trace(TRACE_MASKD, "The main() method exiting with an exit status of " + status + ".");
        System.exit(status);
    }

    static boolean isIPAddress(String inString) {
        int firstPeriodIndex = 0;
        int secondPeriodIndex = 0;
        int thirdPeriodIndex = 0;
        int firstNum = 0;
        int secondNum = 0;
        int thirdNum = 0;
        int fourthNum = 0;
        try {
            firstPeriodIndex = inString.indexOf(46);
            if (firstPeriodIndex != -1 && (secondPeriodIndex = inString.indexOf(46, firstPeriodIndex + 1)) != -1 && (thirdPeriodIndex = inString.indexOf(46, secondPeriodIndex + 1)) != -1 && (firstNum = Integer.parseInt(inString.substring(0, firstPeriodIndex))) >= 0 && firstNum <= 255 && (secondNum = Integer.parseInt(inString.substring(firstPeriodIndex + 1, secondPeriodIndex))) >= 0 && secondNum <= 255 && (thirdNum = Integer.parseInt(inString.substring(secondPeriodIndex + 1, thirdPeriodIndex))) >= 0 && thirdNum <= 255 && (fourthNum = Integer.parseInt(inString.substring(thirdPeriodIndex + 1))) >= 0 && fourthNum <= 255) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    static X509Certificate createX509Certificate(String fileName) throws HException, FileNotFoundException {
        FileInputStream fis = null;
        CertificateFactory cf = null;
        X509Certificate cert = null;
        BufferedInputStream bis = null;
        fis = new FileInputStream(fileName);
        bis = new BufferedInputStream(fis);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new HException(e);
        }
        try {
            if (bis.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bis);
                if (bis.available() > 0) {
                    throw new HException("More than one certificate in the file, " + fileName);
                }
                return cert;
            }
            throw new HException("No certificate in the file, " + fileName);
        }
        catch (CertificateException e) {
            throw new HException(e);
        }
        catch (IOException e) {
            throw new HException(e);
        }
    }

    static String getConfiguredOpenSSLDir() throws CertConfigException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath("openssl");
            if (result == null) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 21).log();
                throw new CertConfigException("Null returned from DDFC while getting the file path for openssl.", null);
            }
            return result;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting openssl executable directory : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw new CertConfigException(e);
        }
    }

    static String getConfiguredTempDir() throws CertConfigException {
        String result = null;
        try {
            result = BaseFileControl.getFilePath("tmp");
            if (result == null) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 21).log();
                throw new CertConfigException("Null returned from DDFC while getting the temporary directory", null);
            }
            return result;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting temporary directory : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw new CertConfigException(e);
        }
    }

    static String getConfiguredServerCertFileName() throws CertConfigException {
        return CertUtils.getFQFileName("server.crt");
    }

    static String getConfiguredServerKeyFileName() throws CertConfigException {
        return CertUtils.getFQFileName("server.key");
    }

    static String getConfiguredSigningChainFileName() throws CertConfigException {
        return CertUtils.getFQFileName("signing_chain.crts");
    }

    static String getConfiguredArchivedServerCertFileName() throws CertConfigException {
        return CertUtils.getFQFileName("archived.server.crt");
    }

    static String getConfiguredArchivedServerKeyFileName() throws CertConfigException {
        return CertUtils.getFQFileName("archived.server.key");
    }

    static String getConfiguredArchivedSigningChainFileName() throws CertConfigException {
        return CertUtils.getFQFileName("archived.signing_chain.crts");
    }

    static boolean isFullyQualifiedHostName(String hostName) {
        boolean result = false;
        int firstPeriodIndex = 0;
        int secondPeriodIndex = 0;
        Trace.trace(TRACE_MASKT, "->isFullyQualifiedHostName(" + hostName + ")");
        if (hostName != null && hostName.length() > 0 && (firstPeriodIndex = hostName.indexOf(46)) != -1 && firstPeriodIndex < hostName.length() - 1 && (secondPeriodIndex = hostName.indexOf(46, firstPeriodIndex)) != -1 && secondPeriodIndex < hostName.length() - 1) {
            result = true;
        }
        Trace.trace(TRACE_MASKT, "<-isFullyQualifiedHostName(" + hostName + ") returning " + result);
        return result;
    }

    static String getShortHostName(String hostName) {
        String result = null;
        int firstPeriodIndex = 0;
        Trace.trace(TRACE_MASKT, "->getShortHostName(" + hostName + ")");
        if (hostName != null && hostName.length() > 0 && (firstPeriodIndex = hostName.indexOf(46)) != -1) {
            result = hostName.substring(0, firstPeriodIndex);
        }
        Trace.trace(TRACE_MASKT, "<-getShortHostName(" + hostName + ") returning " + result);
        return result;
    }

    static String getDomainName(String hostName) {
        String result = null;
        int firstPeriodIndex = 0;
        Trace.trace(TRACE_MASKT, "->getDomainName(" + hostName + ")");
        if (hostName != null && hostName.length() > 0 && (firstPeriodIndex = hostName.indexOf(46)) != -1 && firstPeriodIndex < hostName.length() - 1) {
            result = hostName.substring(firstPeriodIndex + 1);
        }
        Trace.trace(TRACE_MASKT, "<-getDomainName(" + hostName + ") returning " + result);
        return result;
    }

    static String makeFQHostName(String shortHostName, String domainName) throws IllegalArgumentException {
        String result = null;
        Trace.trace(TRACE_MASKT, "->makeFQHostName(" + shortHostName + ", " + domainName + ")");
        if (shortHostName == null || shortHostName.length() == 0) {
            throw new IllegalArgumentException();
        }
        result = domainName == null || domainName.length() == 0 ? shortHostName : shortHostName + "." + domainName;
        Trace.trace(TRACE_MASKT, "<-makeFQHostName(...) returning " + result);
        return result;
    }

    static HashSet addIPAddresses(HashSet inSet) {
        HashSet result = null;
        NetworkSettings networkSettings = null;
        List networkInterfaceInfo = null;
        NetworkInterfaceInformation curInterfaceInfo = null;
        String curIPAddr = null;
        Trace.trace(TRACE_MASKT, "->getIPAddresses(" + inSet + ")");
        result = inSet == null ? new HashSet() : (HashSet)inSet.clone();
        networkSettings = NetworkSettings.getNetworkSettings();
        if (networkSettings != null && (networkInterfaceInfo = networkSettings.getNetworkInterfaceInfo()) != null) {
            Iterator i = networkInterfaceInfo.iterator();
            while (i.hasNext()) {
                curInterfaceInfo = (NetworkInterfaceInformation)i.next();
                if (curInterfaceInfo == null || curInterfaceInfo.isDhcpClient() || (curIPAddr = curInterfaceInfo.getIpAddr()) == null || curIPAddr.length() <= 0) continue;
                result.add(curIPAddr);
            }
        }
        Trace.trace(TRACE_MASKT, "<-getIPAddresses() returning " + result);
        return result;
    }

    static synchronized boolean install(String fileName, String keyFileName, String chainingFileName, boolean verifyCertFile, boolean verifySigningFile, PanelTasklet panelTasklet) throws HException, FileNotFoundException {
        String hTTPDServerRoot;
        String hMCSSLConfigFile;
        String hTTPDPIDFile;
        String hTTPDExecutable;
        String command;
        block10: {
            String[] subs;
            X509Certificate tempCert;
            block9: {
                command = null;
                hTTPDExecutable = null;
                hTTPDPIDFile = null;
                hMCSSLConfigFile = null;
                hTTPDServerRoot = null;
                tempCert = null;
                subs = null;
                Trace.trace(TRACE_MASKT, "->install(" + fileName + ", " + keyFileName + ", " + chainingFileName + ", " + verifyCertFile + ", " + verifySigningFile + ", " + panelTasklet + ")");
                try {
                    hTTPDServerRoot = BaseFileControl.getFilePath("httpdServerRootDir");
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "HException while getting the HTTPD server root directory  : " + e);
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
                    throw new CertConfigException("Error getting the HTTPD server root directory.", e);
                }
                hTTPDExecutable = CertUtils.getFQFileName("httpd");
                hTTPDPIDFile = CertUtils.getFQFileName("httpd.pid");
                hMCSSLConfigFile = CertUtils.getFQFileName("hmc_ssl.conf");
                if (verifyCertFile) {
                    try {
                        tempCert = CertUtils.createX509Certificate(fileName);
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, "createX509Certificate threw exception : " + e);
                        subs = new String[]{fileName};
                        if (CertMgtPanelUtils.showQuestionMessageBox("0042", "0072", subs, panelTasklet)) break block9;
                        Trace.trace(TRACE_MASKT, "<-install(...) returning false");
                        return false;
                    }
                }
            }
            if (verifySigningFile && chainingFileName != null) {
                try {
                    tempCert = CertUtils.createX509Certificate(chainingFileName);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "createX509Certificate for signing chain file threw exception : " + e);
                    subs = new String[]{chainingFileName};
                    if (CertMgtPanelUtils.showQuestionMessageBox("0042", "0073", subs, panelTasklet)) break block10;
                    Trace.trace(TRACE_MASKT, "<-install(...) returning false");
                    return false;
                }
            }
        }
        command = "installCert " + fileName + " " + keyFileName + " " + CertUtils.getConfiguredServerCertFileName() + " " + CertUtils.getConfiguredServerKeyFileName() + " " + CertUtils.getConfiguredSigningChainFileName() + " " + CertUtils.getConfiguredArchivedServerCertFileName() + " " + CertUtils.getConfiguredArchivedServerKeyFileName() + " " + CertUtils.getConfiguredArchivedSigningChainFileName() + " " + hTTPDExecutable + " " + hTTPDPIDFile + " " + hMCSSLConfigFile + " " + hTTPDServerRoot;
        if (chainingFileName != null) {
            command = command + " " + chainingFileName;
        }
        CertUtils.executeCommand(command);
        Trace.trace(TRACE_MASKT, "<-install(...) returning true");
        return true;
    }

    static synchronized void archiveAndDelete(ServerCert certificate) throws HException {
        ServerCert tempCertificate = null;
        String hTTPDExecutable = null;
        String hTTPDPIDFile = null;
        String hMCSSLConfigFile = null;
        String hTTPDServerRoot = null;
        try {
            hTTPDServerRoot = BaseFileControl.getFilePath("httpdServerRootDir");
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException while getting the HTTPD server root directory  : " + e);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw new CertConfigException("Error getting the HTTPD server root directory.", e);
        }
        hTTPDExecutable = CertUtils.getFQFileName("httpd");
        hTTPDPIDFile = CertUtils.getFQFileName("httpd.pid");
        hMCSSLConfigFile = CertUtils.getFQFileName("hmc_ssl.conf");
        try {
            tempCertificate = new ServerCert(CertUtils.getConfiguredServerCertFileName());
        }
        catch (FileNotFoundException e) {
            throw new HException("Certificate requested to be deleted does not exist.");
        }
        if (!tempCertificate.equalsSomewhat(certificate)) {
            throw new HException("Certificate requested to be deleted does not match that currently being used.");
        }
        CertUtils.executeCommand("deleteCert " + CertUtils.getConfiguredServerCertFileName() + " " + CertUtils.getConfiguredServerKeyFileName() + " " + CertUtils.getConfiguredSigningChainFileName() + " " + CertUtils.getConfiguredArchivedServerCertFileName() + " " + CertUtils.getConfiguredArchivedServerKeyFileName() + " " + CertUtils.getConfiguredArchivedSigningChainFileName() + " " + hTTPDExecutable + " " + hTTPDPIDFile + " " + hMCSSLConfigFile + " " + hTTPDServerRoot);
    }

    static int wholeDaysGreater(Date firstTime, Date secondTime) throws HException {
        GregorianCalendar firstCalendar = null;
        GregorianCalendar secondCalendar = null;
        GregorianCalendar secondCalendarPlusRough = null;
        GregorianCalendar secondCalendarPlusRoughPlusOne = null;
        long milliSecondsGreater = 0L;
        long roughFullDaysLong = 0L;
        int roughFullDays = 0;
        int result = 0;
        Trace.trace(TRACE_MASKT, "->wholeDaysGreater(" + firstTime + ", " + secondTime + ")");
        milliSecondsGreater = firstTime.getTime() - secondTime.getTime();
        if (milliSecondsGreater <= 0L) {
            result = 0;
        } else {
            roughFullDaysLong = milliSecondsGreater / 86400000L;
            if (roughFullDaysLong + 1L > Integer.MAX_VALUE) {
                throw new HException("The number of days between the two dates is too large.");
            }
            roughFullDays = (int)roughFullDaysLong;
            firstCalendar = new GregorianCalendar();
            firstCalendar.setTimeInMillis(firstTime.getTime());
            secondCalendar = new GregorianCalendar();
            secondCalendar.setTimeInMillis(secondTime.getTime());
            secondCalendarPlusRough = secondCalendar;
            secondCalendarPlusRough.add(5, roughFullDays);
            secondCalendarPlusRoughPlusOne = secondCalendar;
            secondCalendarPlusRoughPlusOne.add(5, roughFullDays + 1);
            result = secondCalendarPlusRoughPlusOne.getTimeInMillis() > firstTime.getTime() ? (secondCalendarPlusRough.getTimeInMillis() <= firstTime.getTime() ? roughFullDays : roughFullDays - 1) : roughFullDays + 1;
        }
        Trace.trace(TRACE_MASKT, "<-wholeDaysGreater(...) returning " + result);
        return result;
    }

    static ArrayList getRemovableMediaDevices() throws MediaDeviceException {
        int i;
        ArrayList<RemovableMediaDevice> result = null;
        MediaDeviceIdentifier[] disketteDevices = null;
        MediaDeviceIdentifier[] dvdRAMDevices = null;
        MediaDeviceIdentifier currentDevice = null;
        result = new ArrayList<RemovableMediaDevice>();
        disketteDevices = MediaServices.getMediaServices().getMediaDeviceIdentifiers(1);
        for (i = 0; i < disketteDevices.length; ++i) {
            currentDevice = disketteDevices[i];
            if (currentDevice == null) continue;
            result.add(new RemovableMediaDevice(currentDevice.getDisplayableDeviceDescription(), currentDevice.getDeviceName()));
        }
        dvdRAMDevices = MediaServices.getMediaServices().getMediaDeviceIdentifiers(3);
        for (i = 0; i < dvdRAMDevices.length; ++i) {
            currentDevice = dvdRAMDevices[i];
            if (currentDevice == null) continue;
            result.add(new RemovableMediaDevice(currentDevice.getDisplayableDeviceDescription(), currentDevice.getDeviceName()));
        }
        return result;
    }

    private static synchronized ArrayList getX509Certificates(String fileName) {
        FileInputStream fis = null;
        CertificateFactory cf = null;
        X509Certificate cert = null;
        BufferedInputStream bis = null;
        ArrayList<X509Certificate> result = null;
        Trace.trace(TRACE_MASKF, "->getX509Certificates(" + fileName + ")");
        result = new ArrayList<X509Certificate>();
        try {
            fis = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "FileNotFoundException: " + e);
            return result;
        }
        bis = new BufferedInputStream(fis);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            Trace.trace(TRACE_MASKF, "CertificateException: " + e);
            return result;
        }
        try {
            while (bis.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bis);
                result.add(cert);
            }
            return result;
        }
        catch (CertificateException e) {
            Trace.trace(TRACE_MASKF, "CertificateException: " + e);
            return result;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException: " + e);
            return result;
        }
    }

    private static synchronized ArrayList getX509SigningCertificates() throws CertConfigException {
        return CertUtils.getX509Certificates(CertUtils.getConfiguredSigningChainFileName());
    }

    private static synchronized ArrayList getArchivedX509SigningCertificates() throws CertConfigException {
        return CertUtils.getX509Certificates(CertUtils.getConfiguredArchivedSigningChainFileName());
    }

    static synchronized X509Certificate findArchivedX509SigningCertificate(CertPrincipal issuer) {
        ArrayList certificates = null;
        X509Certificate certificate = null;
        X509Certificate result = null;
        X500Principal currentIssuer = null;
        certificates = CertUtils.getArchivedX509SigningCertificates();
        Iterator i = certificates.iterator();
        while (i.hasNext()) {
            certificate = (X509Certificate)i.next();
            currentIssuer = certificate.getIssuerX500Principal();
            if (currentIssuer == null || !new CertPrincipal(currentIssuer).equals(issuer)) continue;
            result = certificate;
            break;
        }
        return result;
    }

    static synchronized X509Certificate findX509SigningCertificate(CertPrincipal issuer) {
        ArrayList certificates = null;
        X509Certificate certificate = null;
        X509Certificate result = null;
        X500Principal currentSubject = null;
        certificates = CertUtils.getX509SigningCertificates();
        Iterator i = certificates.iterator();
        while (i.hasNext()) {
            certificate = (X509Certificate)i.next();
            currentSubject = certificate.getSubjectX500Principal();
            if (currentSubject == null || !new CertPrincipal(currentSubject).equals(issuer)) continue;
            result = certificate;
            break;
        }
        return result;
    }

    static String getConfiguredSavedKeyFileName() throws CertConfigException {
        return CertUtils.getFQFileName("pending.server.key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static File verifyAndConcatenateCerts(String[] certFileNames, PanelTasklet panelTasklet) throws HException, FileNotFoundException {
        File tempFile;
        block10: {
            String tempFileName = null;
            tempFile = null;
            boolean resultValid = false;
            File tempDir = null;
            String tempDirName = null;
            X509Certificate tempCert = null;
            String[] subs = null;
            Trace.trace(TRACE_MASKT, "-> verifyAndContanateCerts(...)");
            if (certFileNames != null) {
                for (int i = 0; i < certFileNames.length; ++i) {
                    try {
                        tempCert = CertUtils.createX509Certificate(certFileNames[i]);
                        continue;
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, "createX509Certificate threw exception : " + e);
                        subs = new String[]{certFileNames[i]};
                        if (CertMgtPanelUtils.showQuestionMessageBox("0042", "0073", subs, panelTasklet)) continue;
                        Trace.trace(TRACE_MASKT, "<- verifyAndContanateCerts returning null.");
                        return null;
                    }
                }
            }
            tempDirName = CertUtils.getConfiguredTempDir();
            tempDir = new File(tempDirName);
            try {
                try {
                    tempFile = File.createTempFile(TRACE_MASKT, null, tempDir);
                    tempFileName = tempFile.getCanonicalPath();
                    if (certFileNames != null && certFileNames.length > 0) {
                        CertUtils.concatenateFiles(certFileNames, tempFileName);
                        resultValid = true;
                    }
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKD, "IOException caught concatenating certificates: " + e);
                    throw new HException(e);
                }
                Object var12_12 = null;
                if (tempFile == null || resultValid) break block10;
                tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (tempFile != null && !resultValid) {
                    tempFile.delete();
                    tempFile = null;
                }
                throw throwable;
            }
            tempFile = null;
        }
        Trace.trace(TRACE_MASKT, "<- verifyAndContanateCerts returning " + tempFile + ".");
        return tempFile;
    }

    static void appendPropertyValue(String propertyName, String value, StringBuffer buffer) {
        if (value != null && value.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(propertyName);
            buffer.append('=');
            buffer.append(value);
        }
    }

    static String getRandomString() {
        StringBuffer result = null;
        byte[] tempPassPhraseArray = null;
        result = new StringBuffer();
        tempPassPhraseArray = new byte[8];
        new SecureRandom().nextBytes(tempPassPhraseArray);
        for (int i = 0; i < tempPassPhraseArray.length; ++i) {
            result.append(Byte.toString(tempPassPhraseArray[i]));
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void doInstallSelfSigned(ServerCert certificate) throws HException {
        Trace.trace(TRACE_MASKT, "-> doInstallSelfSigned");
        String tempServerCertFileName = null;
        String tempServerKeyFileName = null;
        File tempServerCertFile = null;
        File tempServerKeyFile = null;
        File tempDir = null;
        String tempDirName = null;
        tempDirName = CertUtils.getConfiguredTempDir();
        tempDir = new File(tempDirName);
        try {
            try {
                tempServerCertFile = File.createTempFile(TRACE_MASKT, null, tempDir);
                tempServerKeyFile = File.createTempFile(TRACE_MASKT, null, tempDir);
                tempServerCertFileName = tempServerCertFile.getCanonicalPath();
                tempServerKeyFileName = tempServerKeyFile.getCanonicalPath();
                Trace.trace(TRACE_MASKF, "created temp file tempServerCertFileName: " + tempServerCertFileName);
                Trace.trace(TRACE_MASKF, "created temp file tempServerKeyFileName: " + tempServerKeyFileName);
                certificate.writeToFile(tempServerCertFileName, tempServerKeyFileName, true);
                CertUtils.install(tempServerCertFileName, tempServerKeyFileName, null, false, false, null);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Object var9_7 = null;
            if (tempServerCertFile != null) {
                tempServerCertFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (tempServerCertFile != null) {
                tempServerCertFile.delete();
            }
            if (tempServerKeyFile != null) {
                tempServerKeyFile.delete();
            }
            throw throwable;
        }
        if (tempServerKeyFile != null) {
            tempServerKeyFile.delete();
        }
        Trace.trace(TRACE_MASKT, "<- doInstallSelfSigned");
    }

    static SelfSignedServerCert createCert(ServerCert partialServerCert, boolean enforceDomainPresent) throws UnknownHostException, HException {
        Trace.trace(TRACE_MASKT, "-> createCert(..., " + enforceDomainPresent + ")");
        SelfSignedServerCert result = null;
        HashSet<String> altDNSNames = null;
        HashSet altIPAddresses = null;
        String shortHostName = null;
        Object serverCert = null;
        String hostName = null;
        CertPrincipal tempSubject = null;
        altDNSNames = partialServerCert.getAlternateDNSNames();
        if (altDNSNames == null) {
            altDNSNames = new HashSet<String>();
        }
        if ((altIPAddresses = partialServerCert.getIPAddresses()) == null) {
            altIPAddresses = new HashSet();
        }
        altIPAddresses = CertUtils.addIPAddresses(altIPAddresses);
        hostName = CertUtils.getFQHostName(enforceDomainPresent);
        if (enforceDomainPresent || CertUtils.isFullyQualifiedHostName(hostName)) {
            shortHostName = CertUtils.getShortHostName(hostName);
            if (shortHostName != null && shortHostName.length() > 0) {
                altDNSNames.add(shortHostName);
            }
        } else {
            Trace.trace(TRACE_MASKF, "The canonical host name is not valid: " + hostName);
        }
        tempSubject = partialServerCert.getSubject();
        result = new SelfSignedServerCert(partialServerCert.getNumOfDays(), tempSubject != null ? tempSubject.getCountry() : null, tempSubject != null ? tempSubject.getState() : null, tempSubject != null ? tempSubject.getLocality() : null, tempSubject != null ? tempSubject.getOrg() : null, tempSubject != null ? tempSubject.getOrgUnit() : null, hostName, tempSubject != null ? tempSubject.getEMailAddr() : null, altDNSNames, altIPAddresses, false);
        Trace.trace(TRACE_MASKT, "<- createCert");
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getFQHostName(boolean enforceDomainPresent) throws UnknownHostException, HException {
        InetAddress localHost = null;
        String hostName = null;
        String result = null;
        boolean isFullyQualified = false;
        String exceptionString = null;
        localHost = InetAddress.getLocalHost();
        if (localHost != null) {
            hostName = localHost.getCanonicalHostName();
            if (hostName != null && hostName.length() > 0) {
                isFullyQualified = CertUtils.isFullyQualifiedHostName(hostName);
                if (isFullyQualified) {
                    return hostName;
                }
                if (!enforceDomainPresent) return hostName;
                throw new HException("The host name of the HMC is not fully qualified.");
            }
            exceptionString = "InetAddress.getCanonicalHostName() returned null or an empty string.";
            Trace.trace(TRACE_MASKF, exceptionString);
            new FrameworkLog(CertMgtConstants.LOG_INFO, 1).log();
            throw new UnknownHostException(exceptionString);
        }
        exceptionString = "InetAddress.getLocalHost() returned null.";
        Trace.trace(TRACE_MASKF, exceptionString);
        new FrameworkLog(CertMgtConstants.LOG_INFO, 1).log();
        throw new UnknownHostException(exceptionString);
    }

    /*
     * Loose catch block
     */
    private static void concatenateFiles(String[] fileNames, String resultingFileName) throws HException {
        BufferedOutputStream out;
        block20: {
            out = null;
            BufferedInputStream in = null;
            byte[] buffer = null;
            int bytesRead = 0;
            if (fileNames != null && fileNames.length >= 2) {
                out = new BufferedOutputStream(new FileOutputStream(resultingFileName));
                buffer = new byte[1024];
                for (int i = 0; i < fileNames.length; ++i) {
                    block19: {
                        in = new BufferedInputStream(new FileInputStream(fileNames[i]));
                        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                        Object var9_8 = null;
                        if (in == null) break block19;
                        try {
                            in.close();
                            break block19;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        {
                            break block19;
                            catch (IOException e) {
                                throw new HException("Error reading or writing.", e);
                            }
                        }
                        catch (Throwable throwable) {
                            var9_8 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            in = null;
                            throw throwable;
                        }
                    }
                    in = null;
                }
                Object var12_12 = null;
                if (out == null) break block20;
                try {
                    out.close();
                    break block20;
                }
                catch (IOException e) {
                    // empty catch block
                }
                {
                    break block20;
                    catch (IOException e) {
                        throw new HException("Error opening output file.", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    out = null;
                    throw throwable;
                }
            }
            throw new HException("Not enough filenames to concatenate.");
        }
        out = null;
    }
}

